## TFSA-2022-159: `FractionalMaxPoolGrad` Heap OOB

### CVE Number
CVE-2022-41897

### Impact
If [`FractionMaxPoolGrad`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/kernels/fractional_max_pool_op.cc) is given outsize inputs `row_pooling_sequence` and `col_pooling_sequence`, TensorFlow will crash.

```python
import tensorflow as tf
tf.raw_ops.FractionMaxPoolGrad(
	orig_input = [[[[1, 1, 1, 1, 1]]]],
    orig_output = [[[[1, 1, 1]]]],
    out_backprop = [[[[3], [3], [6]]]],
    row_pooling_sequence = [-0x4000000, 1, 1], 
    col_pooling_sequence = [-0x4000000, 1, 1], 
    overlapping = False
 )
```

### Patches
We have patched the issue in GitHub commit [d71090c3e5ca325bdf4b02eb236cfb3ee823e927](https://github.com/tensorflow/tensorflow/commit/d71090c3e5ca325bdf4b02eb236cfb3ee823e927).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Yu Tian from Qihoo 360 AIVul Team.
