# vim:cindent:ts=4:et:ai:
# $Id: Smb2www.pm,v 1.3 2005-12-06 22:04:37 robert Exp $
# Smb2www parser module for Po4a
# Robert Luberda <robert@debian.org>, Nov 2005
#
use Locale::Po4a::TransTractor qw(process new);

package Locale::Po4a::Smb2www;

use 5.006;
use strict;
use warnings;

require Exporter;

use vars qw(@ISA);
@ISA = qw(Locale::Po4a::TransTractor);

sub initialize {}

sub parse {
    my $self = shift;
    
    my ($line,$lref)=$self->shiftline();
    while (defined($line)) {
    
        next unless ($line =~ /=/) ;

        my ($type,$value) = split (/\s*=\s*/, $line, 2);
        my $comment = undef;
        next if $type eq "lang_charset";
        
        if ($type eq "lang_author") {
            $self->pushline("lang_charset = " . $self->get_out_charset() ."\n");
            $comment = << "EOF"
GENERAL NOTE:  Messages from this file are used in smb2www's HTML pages. 
That's why the `<', '>', and `&' characters *must* be replaced with
suitable HTML entities: `&lt;', `&gt;' and, `&amp;' respectively.
Of course, the above characters may be used as part of HTML tags 
(like `<i>' and `</i>' later in this catalogue.)
 
Please put your e-mail address as the translation of this msgid.
EOF
        }
        $value =~ s/\s+/ /mg;
        $value = $self->translate($value, $lref, $type, ('wrap' => 1, 'comment' => $comment) );
        $value =~ s/\s+/ /mg;
        $value =~ s/@/&#X40;/mg;
        $self->pushline( $type . " " x (13 - length($type)) . "= " . $value . "\n");
        
    } continue {
        ($line,$lref)=$self->shiftline();
    }
}
   
sub docheader {
    return "# This file was generated by po4a::smb2www. Do not edit!\n\n"
}
1;

