#!/bin/bash


verbose=0
force=0
immediate="-i"
my_name="random_write_cp_verify.sh"
sdeb_s="scsi_debug"
# for dd clones by this author, bs=BS is the logical block size
bs=512
# bpt is Blocks Per Transfer and BS*BPT will be the segment size
# in bytes. Large copies are done a segment at a time.
bpt=64
# Other suitable dd clones are sg_dd (in main sg3_utils src directory
# and ddpt in a package of that name. sgh_dd is in the testing
# directory of the sg3_utils package and needs to be made by hand
# (e.g. 'cd sg3_utils_src ; ./bootstrap ; ./configure ; make ;
#        cd testing ; make sgh_dd'
## dd_clone="/home/dougg/scsi/sg3_utils/svn/testing/sgh_dd"
dd_clone="sg_dd"
## dd_clone="ddpt"

usage()
{
  echo "Usage: random_write_cp_verify [-f] [-h] [-v] [-w] <device1> <device2>"
  echo "  where:"
  echo "    -f, --force          needed if <device1> or <device2> is not"
  echo "                         generated by the scsi_debug module"
  echo "    -h, --help           print usage message"
  echo "    -v, --verbose        more verbose output"
  echo "    -w, --wait           wait for each start to complete"
  echo "    <device1>            random data will be written to this device"
  echo "    <device2>            data on <device1> copied to this device"
  echo ""
  echo "Writes random data to first disk/device then copies that to second"
  echo "disk/device. Then it does a verify/compare of the two devices."
  echo "BEWARE: the contents of <device1> and <device2> will be DESTROYED."
}

# Additional command line options/operands can be added to or removed from
# th SDP_OPTS array
SDP_OPTS=( "bs=${bs}" "bpt=${bpt}" -v iflag=sgio oflag=sgio )
##SDP_OPTS=( "bs=${bs}" "bpt=${bpt}" -v iflag=pt oflag=pt )
# echo "${SDP_OPTS[@]}"


opt="$1"
while test ! -z "$opt" -a -z "${opt##-*}"; do
  opt=${opt#-}
  case "$opt" in
    f|-force) force=$((${force} + 1)) ;;
    h|-help) usage ; exit 0 ;;
    v|-verbose) verbose=$((${verbose} + 1)) ;;
    w|-wait) immediate="" ;;
    *) echo "Unknown option: -$opt " ; echo "" ; usage ;exit 1 ;;
  esac
  shift
  opt="$1"
done

if [ $# -lt 2 ]
  then
    echo "Missing arguments ..."
    echo ""
    usage
    exit 1
fi

echo "verbose=${verbose}"

if [ -d /sys/class/scsi_host ] && [ ! -w /sys/class/scsi_host ]; then
  echo "You need to run ${my_name} as root"
  exit 2
fi

INQ=$(sg_inq --maxlen=36 ${1} 2>/dev/null)
if [ ${?} -ne 0 ]; then 
	echo "unable to open ${1} with sg_inq"
	exit
fi
IPROD=$(echo "$INQ" | grep 'Product identification:' | sed 's/^[^:]*: \(.*\)$/\1/')
if [ ${IPROD} != ${sdeb_s} ]; then
	if [ ${force} -lt 2 ]; then
		echo -n "need to give use scsi_debug device or use '--force' "
		echo "twice"
		exit 2
	fi
fi
INQ=$(sg_inq --maxlen=36 ${2} 2>/dev/null)
if [ ${?} -ne 0 ]; then 
	echo "unable to open ${2} with sg_inq"
	exit
fi
IPROD=$(echo "$INQ" | grep 'Product identification:' | sed 's/^[^:]*: \(.*\)$/\1/')
if [ ${IPROD} != ${sdeb_s} ]; then
	if [ ${force} -lt 2 ]; then
		echo -n "need to give use scsi_debug device or use '--force' "
		echo "twice"
		exit 2
	fi
fi

# Write random data to $1
echo ${dd_clone} iflag=random of=${1} "${SDP_OPTS[@]}"
${dd_clone} iflag=random of=${1} "${SDP_OPTS[@]}"
if [ ${?} -ne 0 ]; then 
	exit
fi

# Copy $1 to $2
echo ${dd_clone} if=${1} of=${2} "${SDP_OPTS[@]}"
${dd_clone} if=${1} of=${2} "${SDP_OPTS[@]}"
if [ ${?} -ne 0 ]; then 
	exit
fi

# Compare/verify that $1 and $2 are the same. Reports miscompare
# on first segment/lock/byte that isn't the same.
echo ${dd_clone} --verify if=${1} of=${2} "${SDP_OPTS[@]}"
${dd_clone} --verify if=${1} of=${2} "${SDP_OPTS[@]}"
if [ ${?} -ne 0 ]; then 
	exit
fi

