/*
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

import array2iterator = require( '@stdlib/array/to-iterator' );
import iterHead = require( './../../../head' );
import iterSome = require( './../../../some' );
import iterFlow = require( './index' );


// TESTS //

// The function returns a fluent iterator...
{
	// tslint:disable-next-line variable-name
	const FluentIterator = iterFlow( {
		'head': iterHead,
		'some': iterSome
	} );
	const arr = array2iterator( [ 0, 0, 1, 1, 1, 0, 0, 1, 0, 1 ] );

	// tslint:disable-next-line no-unused-expression
	new FluentIterator( arr ); // $ExpectType FluentIterator
}

// The compiler throws an error if the function is provided an unsupported number of arguments...
{
	iterFlow(); // $ExpectError
	iterFlow( {}, {} ); // $ExpectError
}
