/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_RICHBOX_WIDGET_HPP_INCLUDED
#define yf_RICHBOX_WIDGET_HPP_INCLUDED

#include <vector>

#include <QTextEdit>

using std::vector;
class QChar;

class RichBoxWidget: public QTextEdit
{
	Q_OBJECT

 public:
	RichBoxWidget(QWidget* parent = NULL);

 public slots:
	void startTyping(const QString& text, const QString& author);
	void endTyping();
	void keyPressed(QChar symbol);
 signals:
	void markSymbol(QChar symbol);
	void errorOnSymbol();
	void typedSymbol();

 private:
	QString text;
	QString author;
	vector<uint> mistakeIndexes;
	uint currentPosition;

	QString renderHtml() const;
	void insertWraps(QString& result) const;
};

#endif // yf_RICHBOX_WIDGET_HPP_INCLUDED

